<?php
require_once 'api/tmdb.php';

$pageTitle = 'My Favorites - AniCineHub';
$pageDescription = 'Your saved anime, movies, and TV shows';

// Get favorites from session
$favorites = $_SESSION['favorites'] ?? [];

include 'includes/header.php';
?>

<style>
.favorites-hero {
    padding: 40px 0 40px;
    background: linear-gradient(135deg, rgba(0,212,255,0.1) 0%, rgba(162,89,255,0.1) 100%);
    text-align: center;
}

.empty-favorites {
    text-align: center;
    padding: 5rem 2rem;
}

.empty-favorites i {
    font-size: 6rem;
    color: var(--neon-blue);
    margin-bottom: 1.5rem;
    opacity: 0.5;
}

.favorite-card {
    position: relative;
}

.remove-favorite {
    position: absolute;
    top: 10px;
    right: 10px;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: rgba(231, 76, 60, 0.9);
    backdrop-filter: blur(10px);
    border: none;
    color: white;
    cursor: pointer;
    opacity: 0;
    transition: all 0.3s ease;
    z-index: 10;
}

.card:hover .remove-favorite {
    opacity: 1;
}

.remove-favorite:hover {
    background: rgb(192, 57, 43);
    transform: scale(1.1);
}
</style>

<!-- Favorites Hero -->
<section class="favorites-hero">
    <div class="container">
        <h1 style="font-size: 3rem; margin-bottom: 1rem;">
            <i class="fas fa-heart" style="color: var(--neon-blue);"></i> 
            My Favorites
        </h1>
        <p style="font-size: 1.2rem; color: var(--text-gray);">
            Your personalized collection of anime, movies, and TV shows
        </p>
        <?php if (!empty($favorites)): ?>
            <p style="margin-top: 1rem; font-size: 1.1rem;">
                You have <strong style="color: var(--neon-blue);"><?= count($favorites) ?></strong> favorite<?= count($favorites) !== 1 ? 's' : '' ?>
            </p>
        <?php endif; ?>
    </div>
</section>

<!-- Favorites Grid -->
<section class="section">
    <div class="container">
        <?php if (!empty($favorites)): ?>
            <div id="favoritesGrid" class="grid grid-5">
                <?php foreach ($favorites as $id => $item): ?>
                    <div class="card card-entrance favorite-card" data-favorite-id="<?= $id ?>">
                        <button class="remove-favorite" 
                                onclick="removeFromFavorites('<?= $id ?>')"
                                title="Remove from favorites">
                            <i class="fas fa-times"></i>
                        </button>
                        <a href="details.php?id=<?= $id ?>&type=<?= $item['type'] ?? 'movie' ?>">
                            <img src="<?= getImageUrl($item['poster_path'] ?? null) ?>" 
                                 alt="<?= htmlspecialchars($item['title'] ?? 'Untitled') ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($item['title'] ?? 'Untitled') ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($item['rating'] ?? 0) ?>
                                </span>
                                <span style="text-transform: capitalize;">
                                    <?= htmlspecialchars($item['type'] ?? 'movie') ?>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-favorites">
                <i class="fas fa-heart-broken"></i>
                <h2 style="font-size: 2rem; margin-bottom: 1rem;">No Favorites Yet</h2>
                <p style="font-size: 1.2rem; color: var(--text-gray); margin-bottom: 2rem;">
                    Start building your collection by adding anime, movies, and TV shows you love
                </p>
                <div style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
                    <a href="index.php" class="btn btn-primary">
                        <i class="fas fa-home"></i> Browse Homepage
                    </a>
                    <a href="search.php" class="btn btn-secondary">
                        <i class="fas fa-search"></i> Search Content
                    </a>
                    <a href="trending.php" class="btn btn-secondary">
                        <i class="fas fa-fire"></i> View Trending
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<script>
// Check if favorites grid is empty after removals
function checkEmptyState() {
    const grid = document.getElementById('favoritesGrid');
    if (grid && grid.children.length === 0) {
        location.reload();
    }
}

// Override removeFromFavorites to check empty state
const originalRemove = window.removeFromFavorites;
if (originalRemove) {
    window.removeFromFavorites = function(id) {
        originalRemove(id);
        setTimeout(checkEmptyState, 500);
    };
}
</script>

<?php include 'includes/footer.php'; ?>
