<?php
require_once 'api/tmdb.php';

$id = $_GET['id'] ?? null;
$type = $_GET['type'] ?? 'movie';

if (!$id) {
    header('Location: index.php');
    exit;
}

$details = getDetails($id, $type);
$videos = getVideos($id, $type);
$cast = getCast($id, $type);
$recommendations = getRecommendations($id, $type);

// Find trailer - videos are already sorted by priority
$trailer = !empty($videos) ? $videos[0] : null;

$title = $details['title'] ?? $details['name'] ?? 'Untitled';
$pageTitle = $title . ' - AniCineHub';
$pageDescription = $details['overview'] ?? '';

include 'includes/header.php';
?>

<style>
.details-hero {
    position: relative;
    min-height: 600px;
    background-size: cover;
    background-position: center;
}

.details-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, rgba(10,10,10,0.95) 0%, rgba(10,10,10,0.7) 50%, rgba(10,10,10,0.95) 100%);
}

.details-content {
    position: relative;
    z-index: 2;
    display: flex;
    gap: 3rem;
    padding: 3rem 0;
}

.details-poster {
    flex-shrink: 0;
    width: 350px;
}

.details-poster img {
    width: 100%;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-lg);
}

.details-info {
    flex: 1;
    padding-top: 2rem;
}

.details-title {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.details-meta {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
    flex-wrap: wrap;
}

.genre-tags {
    display: flex;
    gap: 0.5rem;
    margin-bottom: 1.5rem;
    flex-wrap: wrap;
}

.genre-tag {
    padding: 0.5rem 1rem;
    background: rgba(0,212,255,0.2);
    border: 1px solid var(--neon-blue);
    border-radius: 20px;
    font-size: 0.9rem;
}

.details-buttons {
    display: flex;
    gap: 1rem;
    margin: 2rem 0;
    flex-wrap: wrap;
}

.overview {
    font-size: 1.1rem;
    line-height: 1.8;
    color: var(--text-gray);
    margin: 2rem 0;
}

.cast-carousel {
    overflow-x: auto;
    scrollbar-width: thin;
    scrollbar-color: var(--neon-blue) transparent;
}

.cast-grid {
    display: flex;
    gap: 1.5rem;
    padding: 1rem 0;
}

.cast-card {
    flex: 0 0 150px;
    text-align: center;
}

.cast-image {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    object-fit: cover;
    margin-bottom: 0.75rem;
    border: 3px solid rgba(0,212,255,0.3);
}

.cast-name {
    font-weight: 600;
    font-size: 0.95rem;
    margin-bottom: 0.25rem;
}

.cast-character {
    font-size: 0.85rem;
    color: var(--text-gray);
}

@media (max-width: 768px) {
    .details-content {
        flex-direction: column;
        gap: 2rem;
    }
    .details-poster {
        width: 100%;
        max-width: 300px;
        margin: 0 auto;
    }
    .details-title {
        font-size: 2rem;
    }
}
</style>

<!-- Details Hero -->
<div class="details-hero" style="background-image: url('<?= getBackdropUrl($details['backdrop_path'] ?? null) ?>');">
    <div class="details-overlay"></div>
    <div class="container">
        <div class="details-content">
            <div class="details-poster">
                <img src="<?= getImageUrl($details['poster_path'] ?? null) ?>" 
                     alt="<?= htmlspecialchars($title) ?>">
            </div>
            
            <div class="details-info">
                <a href="javascript:history.back()" class="back-button">
                    <i class="fas fa-arrow-left"></i> Go Back
                </a>
                <h1 class="details-title"><?= htmlspecialchars($title) ?></h1>
                
                <div class="details-meta">
                    <span class="rating" style="font-size: 1.2rem; padding: 0.5rem 1rem;">
                        <i class="fas fa-star"></i> 
                        <?= formatRating($details['vote_average'] ?? 0) ?>
                    </span>
                    
                    <?php if (!empty($details['release_date']) || !empty($details['first_air_date'])): ?>
                        <span style="font-size: 1.1rem;">
                            <?= getYear($details['release_date'] ?? $details['first_air_date']) ?>
                        </span>
                    <?php endif; ?>
                    
                    <?php if (!empty($details['runtime'])): ?>
                        <span style="font-size: 1.1rem;">
                            <i class="fas fa-clock"></i> 
                            <?= formatRuntime($details['runtime']) ?>
                        </span>
                    <?php endif; ?>
                    
                    <?php if (!empty($details['status'])): 
                        $status = $details['status'];
                        // Convert "Returning Series" to "Airing" for TV shows
                        if ($type === 'tv' && $status === 'Returning Series') {
                            $status = 'Airing';
                        }
                    ?>
                        <span style="font-size: 1.1rem; color: var(--neon-blue);">
                            <?= htmlspecialchars($status) ?>
                        </span>
                    <?php endif; ?>
                </div>
                
                <?php if (!empty($details['genres'])): ?>
                    <div class="genre-tags">
                        <?php foreach ($details['genres'] as $genre): ?>
                            <span class="genre-tag"><?= htmlspecialchars($genre['name']) ?></span>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                
                <div class="details-buttons">
                    <?php if ($trailer): ?>
                        <button onclick="playTrailer('<?= $trailer['key'] ?>')" class="btn btn-primary">
                            <i class="fas fa-play"></i> Watch Trailer
                        </button>
                    <?php endif; ?>
                    
                    <button class="btn btn-secondary" 
                            data-media-id="<?= $id ?>"
                            data-type="<?= $type ?>"
                            data-title="<?= htmlspecialchars($title) ?>"
                            data-poster="<?= $details['poster_path'] ?? '' ?>"
                            data-rating="<?= $details['vote_average'] ?? 0 ?>">
                        <i class="far fa-heart"></i> Add to Favorites
                    </button>
                </div>
                
                <?php if (!empty($details['overview'])): ?>
                    <div class="overview">
                        <h3 style="color: white; margin-bottom: 1rem;">Overview</h3>
                        <p><?= htmlspecialchars($details['overview']) ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Cast Section -->
<?php if (!empty($cast)): ?>
    <section class="section">
        <div class="container">
            <h2 class="section-title"><i class="fas fa-users"></i> Cast</h2>
            <div class="cast-carousel">
                <div class="cast-grid">
                    <?php foreach (array_slice($cast, 0, 15) as $person): ?>
                        <div class="cast-card">
                            <img src="<?= getImageUrl($person['profile_path'] ?? null, 'w185') ?>" 
                                 alt="<?= htmlspecialchars($person['name'] ?? 'Unknown') ?>" 
                                 class="cast-image"
                                 loading="lazy">
                            <div class="cast-name"><?= htmlspecialchars($person['name'] ?? 'Unknown') ?></div>
                            <div class="cast-character"><?= htmlspecialchars($person['character'] ?? '') ?></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Recommendations Section -->
<?php if (!empty($recommendations['results'])): ?>
    <section class="section" style="background: rgba(30,30,30,0.3);">
        <div class="container">
            <h2 class="section-title"><i class="fas fa-lightbulb"></i> Recommended for You</h2>
            <div class="grid grid-6">
                <?php foreach (array_slice($recommendations['results'], 0, 12) as $item): 
                    $recTitle = $item['title'] ?? $item['name'] ?? 'Untitled';
                    ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $item['id'] ?>&type=<?= $type ?>">
                            <img src="<?= getImageUrl($item['poster_path'] ?? null) ?>" 
                                 alt="<?= htmlspecialchars($recTitle) ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($recTitle) ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($item['vote_average'] ?? 0) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php
// JSON-LD Structured Data for SEO
$jsonLD = [
    "@context" => "https://schema.org",
    "@type" => $type === 'movie' ? "Movie" : "TVSeries",
    "name" => $title,
    "description" => $details['overview'] ?? '',
    "image" => getImageUrl($details['poster_path'] ?? null),
    "datePublished" => $details['release_date'] ?? $details['first_air_date'] ?? '',
    "aggregateRating" => [
        "@type" => "AggregateRating",
        "ratingValue" => $details['vote_average'] ?? 0,
        "ratingCount" => $details['vote_count'] ?? 0
    ]
];

if (!empty($details['genres'])) {
    $jsonLD['genre'] = array_column($details['genres'], 'name');
}
?>

<script type="application/ld+json">
<?= json_encode($jsonLD, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) ?>
</script>

<?php include 'includes/footer.php'; ?>
