<?php
require_once 'api/tmdb.php';

$type = $_GET['type'] ?? 'movie';
$filter = $_GET['filter'] ?? 'trending';
$time = $_GET['time'] ?? 'week';

$pageTitle = ucfirst($filter) . ' ' . ucfirst($type) . ' - AniCineHub';
$pageDescription = 'Discover trending and popular content';

// Fetch data based on parameters
switch ($filter) {
    case 'popular':
        $data = getPopular($type);
        $sectionTitle = 'Popular ' . ucfirst($type);
        break;
    case 'top':
        $data = getTopRated($type);
        $sectionTitle = 'Top Rated ' . ucfirst($type);
        break;
    default:
        if ($type === 'anime') {
            $data = getTrendingAnime($time);
            $sectionTitle = 'Trending Anime';
        } elseif ($type === 'tv') {
            $data = getTrendingTV($time);
            $sectionTitle = 'Trending TV Shows';
        } else {
            $data = getTrendingMovies($time);
            $sectionTitle = 'Trending Movies';
        }
}

include 'includes/header.php';
?>



<!-- Trending Hero -->
<section class="trending-hero">
    <div class="container">
        <h1 style="font-size: 3rem; margin-bottom: 1rem;">
            <i class="fas fa-fire" style="color: var(--neon-blue);"></i> 
            <?= htmlspecialchars($sectionTitle) ?>
        </h1>
        <p style="font-size: 1.2rem; color: var(--text-gray);">
            Discover what's hot right now
        </p>
        
        <!-- Type Tabs -->
        <div class="tabs">
            <a href="trending.php?type=anime&filter=<?= $filter ?>&time=<?= $time ?>" 
               class="tab <?= $type === 'anime' ? 'active' : '' ?>">
                Anime
            </a>
            <a href="trending.php?type=movie&filter=<?= $filter ?>&time=<?= $time ?>" 
               class="tab <?= $type === 'movie' ? 'active' : '' ?>">
                Movies
            </a>
            <a href="trending.php?type=tv&filter=<?= $filter ?>&time=<?= $time ?>" 
               class="tab <?= $type === 'tv' ? 'active' : '' ?>">
                TV Shows
            </a>
        </div>
        
        <!-- Filter Tabs -->
        <div class="tabs">
            <a href="trending.php?type=<?= $type ?>&filter=trending&time=<?= $time ?>" 
               class="tab <?= $filter === 'trending' ? 'active' : '' ?>">
                <i class="fas fa-fire"></i> Trending
            </a>
            <a href="trending.php?type=<?= $type ?>&filter=popular&time=<?= $time ?>" 
               class="tab <?= $filter === 'popular' ? 'active' : '' ?>">
                <i class="fas fa-star"></i> Popular
            </a>
            <a href="trending.php?type=<?= $type ?>&filter=top&time=<?= $time ?>" 
               class="tab <?= $filter === 'top' ? 'active' : '' ?>">
                <i class="fas fa-trophy"></i> Top Rated
            </a>
        </div>
        
        <!-- Time Tabs (only for trending) -->
        <?php if ($filter === 'trending'): ?>
            <div class="tabs">
                <a href="trending.php?type=<?= $type ?>&filter=trending&time=day" 
                   class="tab <?= $time === 'day' ? 'active' : '' ?>">
                    Today
                </a>
                <a href="trending.php?type=<?= $type ?>&filter=trending&time=week" 
                   class="tab <?= $time === 'week' ? 'active' : '' ?>">
                    This Week
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Results Grid -->
<section class="section">
    <div class="container">
        <?php if (!empty($data['results'])): ?>
            <div class="section-header">
                <h2 class="section-title">
                    Showing <?= count($data['results']) ?> results
                </h2>
            </div>
            
            <div class="grid grid-5">
                <?php foreach ($data['results'] as $item): 
                    $title = $item['title'] ?? $item['name'] ?? 'Untitled';
                    $year = $item['release_date'] ?? $item['first_air_date'] ?? '';
                    $itemType = $type === 'anime' ? 'tv' : $type;
                    ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $item['id'] ?>&type=<?= $itemType ?>">
                            <img src="<?= getImageUrl($item['poster_path'] ?? null) ?>" 
                                 alt="<?= htmlspecialchars($title) ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($title) ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($item['vote_average'] ?? 0) ?>
                                </span>
                                <?php if (!empty($year)): ?>
                                    <span><?= getYear($year) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state" style="text-align: center; padding: 4rem 2rem;">
                <i class="fas fa-inbox" style="font-size: 5rem; color: var(--neon-blue); opacity: 0.5; margin-bottom: 1rem;"></i>
                <h3>No Results Found</h3>
                <p>Try adjusting your filters</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
