<?php
if (isset($_GET['file'])) {
    $file = $_GET['file'];
    $path = __DIR__ . '/' . basename($file);

    if (file_exists($path)) {
        $code = file_get_contents($path);

        // ✅ Only show PHP part (before HTML)
        $php_end = strpos($code, '?>');
        if ($php_end !== false) {
            $code = substr($code, 0, $php_end + 2);
        }

        // === NEW: Mask password-like values before highlighting ===
        // 1) mask assignments like: $pwd = 'secret'; or $password="abc";
        $code = preg_replace_callback(
            '/(\$[a-zA-Z0-9_]*?(?:pass|pwd|password|secret)[a-zA-Z0-9_]*\s*=\s*)([\'"])(.*?)(\2)/i',
            function($m){ return $m[1].$m[2].'***'.$m[4]; },
            $code
        );

        // 2) mask array entries like: \'password\' => 'secret'  or "password"=>"..."
        $code = preg_replace_callback(
            '/([\'"](?:pass|pwd|password|secret)[\'"]\s*=>\s*)([\'"])(.*?)(\2)/i',
            function($m){ return $m[1].$m[2].'***'.$m[4]; },
            $code
        );

        // 3) mask defines like: define('PASSWORD','secret');
        $code = preg_replace_callback(
            '/(define\s*\(\s*[\'"](?:pass|pwd|password|secret)[\'"]\s*,\s*)([\'"])(.*?)(\2)/i',
            function($m){ return $m[1].$m[2].'***'.$m[4]; },
            $code
        );

        // 4) mask common JSON-like assignments inside code: "password":"secret"
        $code = preg_replace_callback(
            '/([\'"](?:pass|pwd|password|secret)[\'"]\s*:\s*)([\'"])(.*?)(\2)/i',
            function($m){ return $m[1].$m[2].'***'.$m[4]; },
            $code
        );
        // === end masking ===

        // ✅ Built-in syntax highlighting
        $highlighted = highlight_string($code, true);
    } else {
        $highlighted = "<p style='color:#ff6b6b;'>⚠️ File not found!</p>";
    }
} else {
    $highlighted = "<p style='color:#ff6b6b;'>⚠️ No file specified!</p>";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>💻 View PHP Code</title>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        /* 🌙 Base layout */
        body {
            background: radial-gradient(circle at top left, #0f172a, #1e293b, #0f172a);
            color: #e2e8f0;
            font-family: 'Fira Code', monospace;
            padding: 40px;
            overflow-x: hidden;
        }

        /* 🏷️ Header */
        h1 {
            text-align: center;
            color: #7dd3fc;
            font-size: 28px;
            margin-bottom: 30px;
            letter-spacing: 1px;
            text-shadow: 0 0 10px rgba(59,130,246,0.3);
        }

        /* 💾 Code container */
        .code-container {
            background: rgba(30, 41, 59, 0.95);
            border: 1px solid #334155;
            border-radius: 12px;
            padding: 25px;
            overflow-x: auto;
            box-shadow: 0 0 40px rgba(59,130,246,0.15);
            backdrop-filter: blur(6px);
            transition: all 0.4s ease;
        }
        .code-container:hover {
            box-shadow: 0 0 45px rgba(59,130,246,0.3);
        }

        pre {
            margin: 0;
            white-space: pre-wrap;
            word-wrap: break-word;
            font-size: 15px;
            line-height: 1.6;
        }

        /* 🌈 Syntax colors */
        .code-container span { color: #e2e8f0 !important; }
        .code-container .keyword { color: #ffcc66 !important; font-weight: 600; }
        .code-container .string { color: #7ee787 !important; }
        .code-container .variable { color: #79c0ff !important; }
        .code-container .number { color: #ff9e64 !important; }
        .code-container .tag { color: #d2a8ff !important; font-weight: bold; }
        .code-container .comment { color: #8b949e !important; font-style: italic; }
        .code-container .operator { color: #f472b6 !important; }

        /* 📋 Copy button */
        .copy-btn {
            background: linear-gradient(90deg, #6366f1, #3b82f6);
            border: none;
            color: white;
            padding: 10px 16px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
            margin-bottom: 20px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .copy-btn:hover {
            background: linear-gradient(90deg, #818cf8, #60a5fa);
            transform: scale(1.05);
            box-shadow: 0 0 10px rgba(96,165,250,0.4);
        }

        /* 🏠 Back to Home button */
        .back-btn {
            display: inline-block;
            text-decoration: none;
            margin-top: 25px;
            padding: 12px 26px;
            border-radius: 8px;
            background: linear-gradient(90deg, #10b981, #22c55e);
            color: white;
            font-weight: 600;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 15px rgba(34,197,94,0.3);
            transition: all 0.3s ease;
            position: relative;
        }
        .back-btn:hover {
            transform: scale(1.05) translateY(-2px);
            box-shadow: 0 6px 25px rgba(34,197,94,0.5);
            background: linear-gradient(90deg, #34d399, #16a34a);
        }
        .back-btn::after {
            content: "🏡";
            margin-left: 8px;
            transition: margin-left 0.3s ease;
        }
        .back-btn:hover::after {
            margin-left: 14px;
        }

        /* Center the back button */
        .center {
            text-align: center;
        }
    </style>
</head>
<body>

    <h1>💻 Source Code for login.php</h1>

    <button class="copy-btn" onclick="copyCode()">📋 Copy Code</button>

    <div class="code-container" id="codeBlock">
        <?= $highlighted ?>
    </div>

    <div class="center">
        <a href="login.php" class="back-btn">Back to Home</a>
    </div>

    <script>
        function copyCode() {
            const codeText = document.getElementById('codeBlock').innerText;
            navigator.clipboard.writeText(codeText);
            alert("✅ Code copied to clipboard!");
        }
    </script>
</body>
</html>
