<?php
// Contact Project — Simple Source Viewer
$files = ['db.php', 'index.php', 'update.php', 'delete.php'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Contact Project — Source Code</title>
    <style>
        body {
            background: #111;
            color: #eee;
            font-family: monospace;
            padding: 20px;
        }
        h2 {
            color: #00bfff;
            border-bottom: 1px solid #333;
            padding-bottom: 4px;
        }
        pre {
            background: #1a1a1a;
            padding: 15px;
            border-radius: 8px;
            overflow-x: auto;
            border: 1px solid #333;
            margin-bottom: 25px;
        }
        a {
            color: #00bfff;
            text-decoration: none;
        }
        a:hover { text-decoration: underline; }
        .back {
            display: inline-block;
            margin-bottom: 25px;
            color: #00bfff;
            font-weight: bold;
        }
    </style>
</head>
<body>

<a class="back" href="https://bilalcode.site/projects">⬅ Back to Projects</a>
<h1>Contact Management — Source Code</h1>

<?php
foreach ($files as $file) {
    echo "<h2>$file</h2>";
    if (file_exists($file)) {
        echo "<pre>" . htmlspecialchars(file_get_contents($file)) . "</pre>";
    } else {
        echo "<p style='color:red;'>$file not found.</p>";
    }
}
?>

</body>
</html>