<?php
session_start();

if (!isset($_SESSION['user_name'])) {
    header("Location: login.php");
    exit();
}

$name = $_SESSION['user_name'];
$email = $_SESSION['user_email'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home - Welcome <?php echo htmlspecialchars($name); ?></title>
    <link rel="stylesheet" href="style/home.css">
    <style>
        body {
            font-family: "Poppins", sans-serif;
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: #fff;
            height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 40px 50px;
            text-align: center;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
            max-width: 450px;
        }

        h2 {
            font-size: 28px;
            margin-bottom: 10px;
            color: #fff;
        }

        p {
            font-size: 16px;
            color: #e0e0e0;
            line-height: 1.6;
            margin-bottom: 25px;
        }

        a {
            display: inline-block;
            background-color: #fff;
            color: #2575fc;
            text-decoration: none;
            font-weight: bold;
            padding: 12px 25px;
            border-radius: 30px;
            transition: all 0.3s ease;
        }

        a:hover {
            background-color: #2575fc;
            color: #fff;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.3);
        }

        .icon {
            font-size: 50px;
            margin-bottom: 15px;
            color: #00ffb3;
        }

        .note {
            font-size: 14px;
            margin-top: 15px;
            color: #ffc107;
        }

        .logout {
            background-color: #ff4b5c;
            margin-top: 15px;
        }

        .logout:hover {
            background-color: #ff1f3a;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon">✅</div>
        <h2>Welcome, <?php echo htmlspecialchars($name); ?>!</h2>
        <p>You’ve successfully logged in using <strong><?php echo htmlspecialchars($email); ?></strong>.</p>
        <p>🎉 A confirmation email has been sent to your Gmail account.</p>
        <p class="note">📬 Don’t forget to check your <strong>Spam</strong> or <strong>Promotions</strong> folder — just in case!</p>
        <a href="login.php">Go Back to Login</a>
        <form action="logout.php" method="POST">
            <input class="logout" type="submit" name="logout" value="Logout">
        </form>
    </div>
</body>
</html>
