<?php
// Database Debug Endpoint - Check exam system status
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once '../config/database.php';

$results = [];

try {
    // 1. Check flutter_questions table
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM flutter_questions");
    $row = $stmt->fetch();
    $results['flutter_questions_count'] = $row['count'];
    
    // 2. Check assessments
    $stmt = $pdo->query("SELECT * FROM assessments WHERE exam_code = 'FLUTTER2026'");
    $assessment = $stmt->fetch();
    $results['flutter_assessment'] = $assessment ? [
        'assessment_id' => $assessment['assessment_id'],
        'question_count' => $assessment['question_count'],
        'status' => $assessment['assessment_status']
    ] : null;
    
    // 3. Check learner_responses table structure
    $stmt = $pdo->query("SHOW CREATE TABLE learner_responses");
    $row = $stmt->fetch();
    $results['learner_responses_schema'] = $row['Create Table'] ?? 'Table not found';
    
    // 4. Check active sessions
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM active_sessions WHERE session_status = 'active'");
    $row = $stmt->fetch();
    $results['active_sessions_count'] = $row['count'];
    
    // 5. Check exam_progress
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM exam_progress");
    $row = $stmt->fetch();
    $results['exam_progress_count'] = $row['count'];
    
    // 6. Check learner_responses
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM learner_responses");
    $row = $stmt->fetch();
    $results['learner_responses_count'] = $row['count'];
    
    // 7. Sample learner_responses
    $stmt = $pdo->query("SELECT * FROM learner_responses ORDER BY answered_at DESC LIMIT 5");
    $results['recent_responses'] = $stmt->fetchAll();
    
    // 8. Check foreign keys on learner_responses
    $stmt = $pdo->query("
        SELECT CONSTRAINT_NAME, REFERENCED_TABLE_NAME, REFERENCED_COLUMN_NAME
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND TABLE_NAME = 'learner_responses' 
        AND REFERENCED_TABLE_NAME IS NOT NULL
    ");
    $results['foreign_keys'] = $stmt->fetchAll();
    
    $results['success'] = true;
    $results['message'] = 'Database debug complete';
    
} catch (Exception $e) {
    $results['success'] = false;
    $results['error'] = $e->getMessage();
}

echo json_encode($results, JSON_PRETTY_PRINT);
?>
