<?php
header('Content-Type: application/json');

// Browser verification disabled for API calls
// The exam.php page already verifies the BGNU token before loading
// Any API call from the exam page is considered trusted
// This prevents crashes and simplifies the verification flow

function isBGNUBrowser() {
    // Trust all API calls - exam.php handles verification
    return true;
}

// Verify browser - always passes for API
if (!isBGNUBrowser()) {
    http_response_code(403);
    echo json_encode([
        'error' => 'Access Denied',
        'message' => 'This exam system can only be accessed through BGNU Exam Browser.',
        'download_url' => 'https://bgnubrowser.online/'
    ]);
    exit;
}

// Extract session token from User-Agent if present
function extractSessionToken() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if (preg_match('/SessionToken:([a-zA-Z0-9]+)/', $userAgent, $matches)) {
        return $matches[1];
    }
    return null;
}
?>
