<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BGNU Exam Browser System</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 500px;
            text-align: center;
        }
        h1 { color: #333; margin-bottom: 20px; }
        .subtitle { color: #666; margin-bottom: 30px; }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            margin: 10px;
            transition: transform 0.2s;
        }
        .btn:hover { transform: scale(1.05); }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎓 BGNU Exam Browser</h1>
        <p class="subtitle">Secure Lockdown Examination System</p>
        <a href="admin/" class="btn">📊 Instructor Dashboard</a>
        <a href="exam/" class="btn">📝 Student Exam (BGNU Browser Only)</a>
        <p style="margin-top: 30px; color: #999; font-size: 12px;">
            Powered by bilalcode.site
        </p>
    </div>
</body>
</html>
