-- =====================================================
-- DINO Browser Test Exam - CORRECT Schema
-- Run in phpMyAdmin SQL Tab
-- =====================================================

-- First, create a test instructor with all required fields
INSERT INTO learners (student_code, full_name, email_address, password_hash, account_type) 
VALUES ('INST_001', 'Test Instructor', 'instructor@test.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'instructor')
ON DUPLICATE KEY UPDATE full_name = 'Test Instructor';

-- Get the instructor ID
SET @instructor_id = (SELECT learner_id FROM learners WHERE student_code = 'INST_001' LIMIT 1);

-- Insert test assessment with ALL required fields
INSERT INTO assessments (
    exam_code, 
    assessment_title, 
    assessment_status, 
    total_duration_mins, 
    question_count,
    created_by,
    scheduled_start,
    scheduled_end
) VALUES (
    'TEST2026',
    'DINO Browser Test Exam',
    'active',
    30,
    5,
    @instructor_id,
    NOW(),
    DATE_ADD(NOW(), INTERVAL 30 DAY)
);

-- Insert 5 test questions
INSERT INTO question_bank (assessment_id, question_order, question_prompt, choice_a, choice_b, choice_c, choice_d, correct_choice, point_value) VALUES
((SELECT assessment_id FROM assessments WHERE exam_code = 'TEST2026'), 1, 
 'What is the capital of France?', 
 'London', 'Berlin', 'Paris', 'Madrid', 
 'C', 10),

((SELECT assessment_id FROM assessments WHERE exam_code = 'TEST2026'), 2, 
 'Which planet is known as the Red Planet?', 
 'Venus', 'Mars', 'Jupiter', 'Saturn', 
 'B', 10),

((SELECT assessment_id FROM assessments WHERE exam_code = 'TEST2026'), 3, 
 'What is 7 x 8?', 
 '54', '56', '58', '64', 
 'B', 10),

((SELECT assessment_id FROM assessments WHERE exam_code = 'TEST2026'), 4, 
 'Who painted the Mona Lisa?', 
 'Vincent van Gogh', 'Pablo Picasso', 'Leonardo da Vinci', 'Michelangelo', 
 'C', 10),

((SELECT assessment_id FROM assessments WHERE exam_code = 'TEST2026'), 5, 
 'What is the largest ocean on Earth?', 
 'Atlantic Ocean', 'Indian Ocean', 'Arctic Ocean', 'Pacific Ocean', 
 'D', 10);

SELECT 'Test exam created successfully!' as Result;
