<?php
if (isset($_GET['file'])) {
    $file = $_GET['file'];
    $path = __DIR__ . '/' . basename($file);

    if (file_exists($path)) {
        $code = file_get_contents($path);

        // ✅ Show only PHP section (ignore HTML part)
        $php_end = strpos($code, '?>');
        if ($php_end !== false) {
            $code = substr($code, 0, $php_end + 2);
        }

        // ✅ Hide any password-like strings
        $patterns = [
            '/(\$[a-zA-Z0-9_]*(pass|pwd|password|secret)[a-zA-Z0-9_]*\s*=\s*)([\'"])(.*?)(\3)/i',
            '/([\'"](?:pass|pwd|password|secret)[\'"]\s*=>\s*)([\'"])(.*?)(\2)/i',
            '/(define\s*\(\s*[\'"](?:pass|pwd|password|secret)[\'"]\s*,\s*)([\'"])(.*?)(\2)/i',
            '/([\'"](?:pass|pwd|password|secret)[\'"]\s*:\s*)([\'"])(.*?)(\2)/i'
        ];
        foreach ($patterns as $p) {
            $code = preg_replace_callback($p, fn($m) => $m[1] . $m[2] . '***' . $m[count($m) - 1], $code);
        }

        // ✅ Syntax highlight
        $highlighted = highlight_string($code, true);
    } else {
        $highlighted = "<p style='color:#f87171;'>⚠️ File not found!</p>";
    }
} else {
    $highlighted = "<p style='color:#f87171;'>⚠️ No file specified!</p>";
    $file = "unknown.php";
}

// ✅ Extract filename for title/header/button
$filename = htmlspecialchars(basename($file));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>💻 Source Code for <?= $filename ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        /* 🌙 Modern clean theme */
        body {
            background: linear-gradient(135deg, #0f172a, #1e293b, #111827);
            color: #e2e8f0;
            font-family: 'Fira Code', monospace;
            padding: 40px;
            overflow-x: hidden;
        }

        h1 {
            text-align: center;
            color: #a5f3fc;
            font-size: 28px;
            margin-bottom: 30px;
            letter-spacing: 1px;
            text-shadow: 0 0 10px rgba(56,189,248,0.3);
        }

        .code-container {
            background: rgba(30, 41, 59, 0.9);
            border: 1px solid #334155;
            border-radius: 12px;
            padding: 25px;
            overflow-x: auto;
            box-shadow: 0 0 40px rgba(56,189,248,0.1);
            backdrop-filter: blur(8px);
            transition: all 0.4s ease;
        }
        .code-container:hover {
            box-shadow: 0 0 50px rgba(56,189,248,0.3);
        }

        pre {
            margin: 0;
            white-space: pre-wrap;
            word-wrap: break-word;
            font-size: 15px;
            line-height: 1.6;
        }

        /* 🌈 Soft colorful syntax theme */
        .code-container span { color: #e2e8f0 !important; }
        .code-container .keyword { color: #fbbf24 !important; font-weight: 600; }
        .code-container .string { color: #4ade80 !important; }
        .code-container .variable { color: #60a5fa !important; }
        .code-container .number { color: #f472b6 !important; }
        .code-container .tag { color: #c084fc !important; font-weight: bold; }
        .code-container .comment { color: #94a3b8 !important; font-style: italic; }
        .code-container .operator { color: #f59e0b !important; }

        /* 📋 Copy button */
        .copy-btn {
            background: linear-gradient(90deg, #6366f1, #3b82f6);
            border: none;
            color: white;
            padding: 10px 16px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
            margin-bottom: 20px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .copy-btn:hover {
            background: linear-gradient(90deg, #818cf8, #60a5fa);
            transform: scale(1.05);
            box-shadow: 0 0 10px rgba(96,165,250,0.4);
        }

        /* 🏠 Back to Home button */
        .back-btn {
            display: inline-block;
            text-decoration: none;
            margin-top: 25px;
            padding: 12px 26px;
            border-radius: 8px;
            background: linear-gradient(90deg, #14b8a6, #22d3ee);
            color: white;
            font-weight: 600;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 15px rgba(34,211,238,0.3);
            transition: all 0.3s ease;
            position: relative;
        }
        .back-btn:hover {
            transform: scale(1.05) translateY(-2px);
            box-shadow: 0 6px 25px rgba(34,211,238,0.5);
            background: linear-gradient(90deg, #2dd4bf, #0ea5e9);
        }
        .back-btn::after {
            content: "🏡";
            margin-left: 8px;
            transition: margin-left 0.3s ease;
        }
        .back-btn:hover::after {
            margin-left: 14px;
        }

        .center {
            text-align: center;
        }
    </style>
</head>
<body>

    <h1>💻 Source Code for <?= $filename ?></h1>

    <button class="copy-btn" onclick="copyCode()">📋 Copy Code</button>

    <div class="code-container" id="codeBlock">
        <?= $highlighted ?>
    </div>

    <div class="center">
        <a href="<?= $filename ?>" class="back-btn">Back to Home</a>
    </div>

    <script>
        function copyCode() {
            const codeText = document.getElementById('codeBlock').innerText;
            navigator.clipboard.writeText(codeText);
            alert("✅ Code copied to clipboard!");
        }
    </script>
</body>
</html>


 