<?php
require_once '../config/database.php';
require_once 'verify-browser.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

$data = json_decode(file_get_contents('php://input'), true);

$session_token = $data['session_token'] ?? '';
$question_id = $data['question_id'] ?? 0;
$selected_choice = $data['selected_choice'] ?? '';
$response_time = $data['response_time_seconds'] ?? 0;

if (empty($session_token) || empty($question_id) || empty($selected_choice)) {
    http_response_code(400);
    die(json_encode(['error' => 'Missing required fields']));
}

try {
    // Insert or update answer
    $stmt = $pdo->prepare("
        INSERT INTO learner_responses (session_token, question_id, selected_choice, response_time_seconds, answered_at)
        VALUES (?, ?, ?, ?, NOW())
        ON DUPLICATE KEY UPDATE 
            selected_choice = VALUES(selected_choice),
            response_time_seconds = VALUES(response_time_seconds),
            answered_at = NOW()
    ");

    $stmt->execute([$session_token, $question_id, $selected_choice, $response_time]);

    echo json_encode([
        'success' => true,
        'message' => 'Answer saved',
        'question_id' => $question_id
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to save answer', 'details' => $e->getMessage()]);
}
?>
