<?php
$JWT_SECRET="SUPER_SECRET_KEY_2025_ChangeThis";

function base64UrlEncode($data){return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');}
function base64UrlDecode($data){return base64_decode(strtr($data, '-_', '+/'));}

function generateJWT($uid,$role){
 global $JWT_SECRET;
 $header=base64UrlEncode(json_encode(['alg'=>'HS256','typ'=>'JWT']));
 $payload=base64UrlEncode(json_encode([
   'iss'=>"unitransit",
   'iat'=>time(),
   'exp'=>time()+604800,
   'user_id'=>$uid,
   'role'=>$role
 ]));
 $signature=base64UrlEncode(hash_hmac('sha256',"$header.$payload",$JWT_SECRET,true));
 return "$header.$payload.$signature";
}

function verifyJWT($jwt){
 global $JWT_SECRET;
 $parts=explode('.',$jwt);
 if(count($parts)!=3) return false;
 list($h,$p,$s)=$parts;
 $calc=base64UrlEncode(hash_hmac('sha256',"$h.$p",$JWT_SECRET,true));
 if(!hash_equals($calc,$s)) return false;
 $data=json_decode(base64UrlDecode($p));
 if($data->exp < time()) return false;
 return $data;
}
?>